<?php

namespace CMEN\GoogleChartsBundle\GoogleCharts\Options\SankeyDiagram;

use CMEN\GoogleChartsBundle\GoogleCharts\Options\ColorsTrait;
use CMEN\GoogleChartsBundle\GoogleCharts\Options\WidthTrait;

/**
 * @author Christophe Meneses
 */
class Node
{
    /**
     * @var Label
     */
    protected $label;

    /**
     * Allows you to select nodes.
     *
     * @var bool
     */
    protected $interactivity;

    /**
     * Horizontal distance between the label and the node.
     *
     * @var int
     */
    protected $labelPadding;

    /**
     * Vertical distance between nodes.
     *
     * @var int
     */
    protected $nodePadding;

    use WidthTrait;

    use ColorsTrait;

    /**
     * Sets a coloring mode for the sankey nodes. Possible values:
     *      'unique' - Each node will receive a unique color.
     *
     * @var string
     */
    protected $colorMode;

    /**
     * Node constructor.
     */
    public function __construct()
    {
        $this->label = new Label();
    }

    /**
     * @return Label
     */
    public function getLabel()
    {
        return $this->label;
    }

    /**
     * @param bool $interactivity
     *
     * @return $this
     */
    public function setInteractivity($interactivity)
    {
        $this->interactivity = $interactivity;

        return $this;
    }

    /**
     * @param int $labelPadding
     *
     * @return $this
     */
    public function setLabelPadding($labelPadding)
    {
        $this->labelPadding = $labelPadding;

        return $this;
    }

    /**
     * @param int $nodePadding
     *
     * @return $this
     */
    public function setNodePadding($nodePadding)
    {
        $this->nodePadding = $nodePadding;

        return $this;
    }

    /**
     * @param string $colorMode
     *
     * @return $this
     */
    public function setColorMode($colorMode)
    {
        $this->colorMode = $colorMode;

        return $this;
    }
}
